﻿using System;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;
using gov.va.med.VBECS.Communication.Common;

namespace gov.va.med.VBECS.Communication.Utils
{
    public class BinaryMessageSerializer : IMessageSerializer
    {
        readonly string _path = Path.GetDirectoryName(typeof(BinaryMessageSerializer).Assembly.Location);

        public void SerializeObject(string filename, IMessage objectToSerialize)
        {
            if (filename == null)
                throw new ArgumentException("File name is null");
            filename = Path.Combine(_path, filename.Replace('-', '_'));
            Directory.CreateDirectory(Path.GetDirectoryName(filename) ?? "");
            Stream stream = File.Open(filename, FileMode.Create);
            var bFormatter = new BinaryFormatter();
            bFormatter.Serialize(stream, objectToSerialize);
            stream.Close();
        }

        public IMessage DeSerializeObject(string filename)
        {
            filename = Path.Combine(_path, filename.Replace('-', '_'));
            Stream stream = File.Open(filename, FileMode.Open);
            var bFormatter = new BinaryFormatter();
            var objectToSerialize = (IMessage)bFormatter.Deserialize(stream);
            stream.Close();
            return objectToSerialize;
        }
    }
}